#!/bin/bash

# Example Usage: HOST=localhost:9200 ./put.sh

set -eu

for TEMPLATE_PATH in $(ls tpl); do
  TEMPLATE_NAME=$(basename "$TEMPLATE_PATH" .jsonc)
  echo -e "$TEMPLATE_NAME:"
  curl -XPUT "http://localhost:9200/_template/$TEMPLATE_NAME?include_type_name=true" -H "Content-Type: application/json" --data-binary @tpl/$TEMPLATE_PATH
  echo -e ""
done
