# Recall Indices & Content For Stream in ELK v7

Last updated: 2020.07.06

Recall Content can be added to any customer's Stream Elasticsearch & Kibana Index.

This guide will explain how a customer is able to quickly & easily add this data.

After completing these steps, the user will have these items on their ELK stack:
* Index templates in ElasticSearch that will parse fields correctly
* Kibana index patterns that will set the timestamp & representation of each index
* Kibana saved searches for useful queries, such as the Vectra Security Assessment.
* Dashboards, such as VPN overview dashboard, and the Host Dashboard.

## Elastic templates
This zip file contains the templates that are used to store the network metadata from Stream in a multi-index setup.

### Install the templates on a given elastic search instance

run `HOST=localhost:9200 ./put.sh` to upload all the existing templates to the local ES

**OR**

You can use the following `curl` command to install a given template:

```bash
curl -XPUT $HOST/_template/$TEMPLATE_NAME?include_type_name=true -H "Content-Type: application/json" --data-binary "@$TEMPLATE_PATH"
```

Be sure to populate `$HOST`, `$TEMPLATE_NAME` and `$TEMPLATE_PATH` with the proper data.

For instance:

```bash
curl -XPUT http://localhost:9200/_template/metadata_isession?include_type_name=true \
  -H "Content-Type: application/json" \
  --data-binary "@tpl/metadata_isession.jsonc"
```

More info on how to load templates can be found in [the official ElasticSearch templates docs](https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-templates.html).


## Kibana-state

`./kibana-state/` is a store for a Kibana specific state, where the Kibana index patterns are stored.


### Adding Stream index patterns

- Before adding index patterns, ensure that index templates have been added to ES (`HOST=localhost:9200 ./put.sh`)
- Go to kibana UI, Management, Saved Objects Section. /app/kibana#/management/kibana/objects
- Click import, and select recall_kibana_indices.ndjson.

